/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospException;
import jp.mosp.system.dto.MCodeDto;

public class LateReasonCardVo extends ReasonMenuVo {

	private static final long serialVersionUID = -6715261187985051137L;

	// URLAJSt@CACSSt@C
	private static final String RETURN_URL = "/jsp/system/lateReasonCard.jsp";
	private static final String EXTRA_JS   = "/pub/system/js/lateReasonCard.js";
	private static final String EXTRA_CSS  = "/pub/system/css/lateReasonCard.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_LATE_REASON;

	// 萔
	public static final int MODE_UPDATE = 1;

	// p[^
	public static final String PRM_TXT_LATE_REASON 	= "txtLateReason";

	// tB[h
	private String[]	aryLateReason;   
	private String		txtLateReason;

	// [h(1FXV)
	private int mode;

	// tB[hyѐ
	public static final String NAM_LATE_REASON 	= CommonConst.NAM_ARRIVE_LATE + CommonConst.NAM_REASON;

	public static final int	LEN_LATE_REASON 	= 15;

	/**
	 * RXgN^
	 */
	public LateReasonCardVo() {
		super();
		mode = 0;
		setExtraCss(EXTRA_CSS);
		addExtraJs(EXTRA_JS);
		setRetUrl(RETURN_URL);
		aryLateReason = new String[0];
	}

	/**
	 * p[^ݒ
	 */
	public void setParams(HttpServletRequest request, int i) {
		txtLateReason = request.getParameter(PRM_TXT_LATE_REASON + i);
	}

	/**
	 * tB[hݒ
	 * @param listLate	xRXg
	 */
	public void setFieldsLateReason(List listLate) {
		// Xg̐ݒ
		list = listLate;
		// f[^̎擾
		count = 10;
		// z̏
		aryLateReason		= new String[count];
		// f[^̐ݒ
		int i = 0;
		Iterator it = listLate.iterator();
		while (it.hasNext()) {
			MCodeDto dto = (MCodeDto)it.next();
			aryLateReason[i] = escapeHTML(dto.getTName());
			i++;
		}
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFieldLateReason(MCodeDto dto, int i) {
		dto.setTId(CommonConst.TID_LATE_REASON);
		dto.setTCode(String.valueOf(i));
		dto.setTName(txtLateReason);
		dto.setTChange("");
	}

	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validateLateReason(int i) throws MospException {
		// ÓmFJn
		startValidation();
		// 񒷊mF
		checkLength  (txtLateReason, LEN_LATE_REASON, NAM_LATE_REASON, PRM_TXT_LATE_REASON + i);
		// ÓmFI
		endValidation();
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}

	// ANZT\bh
	public String[] getEscAryLateReason() 	{ return aryLateReason.clone()		; }

	public String getTxtLateReason() 		{ return txtLateReason				; }
	public String getEscTxtLateReason() 	{ return escapeHTML(txtLateReason)	; }

	public void setTxtLateReason(String txtLateReason) { this.txtLateReason = txtLateReason; }

	public void setMode(int mode) { this.mode = mode; }
	public int getMode() { return mode; }

}
